<?php
/**
 * Plugin Name:  درگاه پرداخت بانک ملت
 * Description: افزونه درگاه پرداخت بانک ملت | برای استفاده از افزونه کدمیانبر [WPBEGPAY_SC] را در پست یا برگه مورد نظر خود وارد کنید.
 * Version: 1.2
 * Author: Wp-Beginner.ir
 * Author URI: http://wp-beginner.ir
 * License: تمامي حقوق اين افزونه براي گروه Wp-Beginner محفوظ مي باشد
 */

define( 'WPBEGPAY_VERSION', '1.0.0' );

define( 'WPBEGPAY_PATH', plugin_dir_path( __FILE__ ) );

$wpBeginnerMellatBankGateway = new wpBeginner();

class wpBeginner{
	
	/**
	 * The DB version. Used for SQL install and upgrades.
	 *
	 * Should only be changed when needing to change SQL
	 * structure or custom capabilities.
	 *
	 * @since 1.1.0
	 * @var string
	 * @access protected
	 */
	protected $WPBEGPAY_db_version = '1.1.0';
	
	/**
	 * order_table_name
	 *
	 * @var mixed
	 * @access public
	 */
	public $orders_table_name;

	public function __construct(){
		
		// Wordpress database
		global $wpdb;
		
		// Setup global database table names
		$this->orders_table_name 	= $wpdb->prefix . 'WPBEGPAY_orders';
		
		// Load plugin components
		require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . '/core/class-main.php' );
		require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . '/core/shortcode.php' );

		// Make object of class components
		$pluginComponents = new pluginComponents();

		// Adds a Settings link to the Plugins page
		add_filter( 'plugin_action_links_'. plugin_basename(__FILE__), array( &$this, 'plugin_action_links' ));

		// Check the db version and run SQL install, if needed
		add_action( 'plugins_loaded', array( &$this, 'update_db_check' ) );
		
		add_action( "admin_enqueue_scripts", array( &$this, 'plugin_refrences' ) );

	}

	/**
	 * Add Settings link to Plugins page
	 *
	 * @since 1.0
	 * @return $links array Links to add to plugin name
	 */
	public function plugin_action_links( $links ) {
			$links[] = '<a href="admin.php?page=WPBEGPAY-settings">' . __( 'تنظیمات' , 'WPBEGPAY') . '</a>';
			$links[] = '<a href="http://wp-beginner.ir/">' . __( 'آموزش وردپرس' , 'WPBEGPAY') . '</a>';

		return $links;
	}


	/**
	 * Check database version and run SQL install, if needed
	 *
	 * @since 2.1
	 */
	public function update_db_check() {
		// Add a database version to help with upgrades and run SQL install
		if ( !get_option( 'WPBEGPAY_db_version' ) ) {
			update_option( 'WPBEGPAY_db_version', $this->WPBEGPAY_db_version );
			$this->install_db();
		}

		// If database version doesn't match, update and run SQL install
		if ( version_compare( get_option( 'WPBEGPAY_db_version' ), $this->WPBEGPAY_db_version, '<' ) ) {
			update_option( 'WPBEGPAY_db_version', $this->WPBEGPAY_db_version );
			$this->install_db();
		}
	}

	/**
	 * Install database tables
	 *
	 * @since 1.0
	 */
	static function install_db() {
		global $wpdb;

		$orders_table_name      = $wpdb->prefix . 'WPBEGPAY_orders';

		// Explicitly set the character set and collation when creating the tables
		$charset = ( defined( 'DB_CHARSET' && '' !== DB_CHARSET ) ) ? DB_CHARSET : 'utf8';
		$collate = ( defined( 'DB_COLLATE' && '' !== DB_COLLATE ) ) ? DB_COLLATE : 'utf8_general_ci';

		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		$orders_sql = "CREATE TABLE $orders_table_name (
				order_id BIGINT(20) NOT NULL AUTO_INCREMENT,
				order_status VARCHAR(5) NOT NULL,
				order_amount BIGINT(100) NOT NULL,
				order_date TEXT,
				order_ip TEXT,
				order_orderid VARCHAR(20) NOT NULL,
				order_referenceId BIGINT(80) DEFAULT '0',
				order_refid VARCHAR(80) DEFAULT '0',
				order_settle VARCHAR(5),
				order_name_surname VARCHAR(50),
				order_phone BIGINT(15),
				order_email TEXT,
				order_des TEXT,
				PRIMARY KEY  (order_id)
			) DEFAULT CHARACTER SET $charset COLLATE $collate;";

		// Create or Update database tables
		dbDelta( $orders_sql );
	}
	

	/**
	 * Queue plugin scripts for order page
	 *
	 * @since 1.0
	 */
	public function plugin_refrences() {
	
		wp_enqueue_style( 'WPBEGPAY-orders-css', plugins_url("css/Bank-Mellat-Plugin.css", __FILE__ ), array(), '1.0.0' );
		wp_enqueue_script( 'WPBEGPAY-help-js', plugins_url("js/jquery.accordion.js", __FILE__ ), "jquery", '1.0.0' );

		
	}
}
?>